package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.Protections;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.Map;

/**
 * PUT /{server}/protections
 */
public class PerforceUpdateProtectionsRoute implements
        Route,
        P4Methods,
        HasGson,
        ModelConversion,
        ResultMapMethods,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            Protections protections = readModel(request, Protections.class);

            Map<String, Object> inputMap = toRequestMap(protections);

            return toCommandResponse(execInput(serverHandle, inputMap, "protect", "-i"));
        });
    }
}
