package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.ServerCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

/**
 * PATCH /p4/:api/servers/:server
 */
public class PerforceUpdateServerRoute implements
        Route,
        P4Methods,
        ResultMapMethods,
        ServerSpecMethods,
        ModelConversion,
        HasGson,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String serverId = request.params("serverId");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            ServerCommand updateCommand = readModel(request, ServerCommand.class);
            Map<String, Object> updates = toRequestMap(updateCommand);

            List<ResultMap> results = exec(serverHandle, "server", "-o", serverId);
            ResultMap resultMap = firstResultOrFail(results);
            Map<String, Object> current = toRequestMap(toServerCommand(resultMap));

            current.putAll(updates);

            return toCommandResponse(saveServerSpec(serverHandle, current));
        });
    }
}
