package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.StreamRoute;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.StreamCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

/**
 * PATCH /p4/:api/streams/*
 */
public class PerforceUpdateStreamRoute implements
        Route,
        P4Methods,
        ModelConversion,
        ResultMapMethods,
        HasGson,
        StreamRoute,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        String stream = getStream(request);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            StreamCommand updateCommand = readModel(request, StreamCommand.class);

            Map<String, Object> updates = toRequestMap(updateCommand);

            List<ResultMap> results = exec(serverHandle, "stream", "-o", stream);
            ResultMap resultMap = firstResultOrFail(results);

            Supplier<String> offsetSupplier = offsetSupplier(serverHandle);

            Map<String, Object> current = toRequestMap(toStreamCommand(resultMap, offsetSupplier));

            current.putAll(updates);

            return toCommandResponse(execInput(serverHandle, current, "stream", "-i"));
        });
    }
}



