package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.Triggers;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.Map;

/**
 * PUT /p4/:api/triggers
 */
public class PerforceUpdateTriggersRoute implements
        P4Methods,
        ResultMapMethods,
        HasGson,
        ModelConversion,
        Route,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        Triggers triggers = readModel(request, Triggers.class);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            Map<String, Object> inputMap = toRequestMap(triggers);
            return toCommandResponse(execInput(serverHandle, inputMap, "triggers", "-i"));
        });
    }
}
