package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UserRoute;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.UserCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

import static spark.Spark.halt;

/**
 * PATCH /p4/:api/users/:user
 */
public class PerforceUpdateUserRoute implements
        Route,
        P4Methods,
        ResultMapMethods,
        UserRoute,
        ModelConversion,
        HasGson,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String user = request.params("user");

        UserCommand updateCommand = readModel(request, UserCommand.class);
        Map<String, Object> updates = toRequestMap(updateCommand);

        return withServerHandle(server, sessionData, settings, serverHandle -> {

            List<ResultMap> results = exec(serverHandle, "user", "-o", user);
            ResultMap resultMap = firstResultOrFail(results);

            if (isInvalidUserEmail(resultMap)) {
                halt(404);
            }

            Supplier<String> offsetSupplier = offsetSupplier(serverHandle);

            UserCommand savedCommand = toUserCommand(resultMap, offsetSupplier);

            Map<String, Object> saved = toRequestMap(savedCommand);

            saved.putAll(updates);

            return toCommandResponse(execInput(serverHandle, saved, "user", "-f", "-i"));
        });
    }
}
