package com.perforce.hws.server.sessions;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * Each time the user logs in, we collect information here to be used to connect to backend systems.
 * <p>
 * Each new backend system type should probably be added to this pool of information.
 */
public class SessionData {

    private UUID id = UUID.randomUUID();
    private Map<String, P4LoginInfo> p4LoginInfoMap = new HashMap<>();
    private String raymondTicket = null;
    private Instant expires = null;

    public SessionData() {
    }

    /**
     * Each session is just given a random ID.
     */
    public UUID getId() {
        return id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getRaymondTicket() {
        return raymondTicket;
    }

    public void setRaymondTicket(String raymondTicket) {
        this.raymondTicket = raymondTicket;
    }

    public Map<String, P4LoginInfo> getP4LoginInfoMap() {
        return p4LoginInfoMap;
    }

    public void setP4LoginInfoMap(Map<String, P4LoginInfo> p4LoginInfoMap) {
        this.p4LoginInfoMap = p4LoginInfoMap;
    }

    public Instant getExpires() {
        return expires;
    }

    public void setExpires(Instant expires) {
        this.expires = expires;
    }

    public static class P4LoginInfo {

        private String user;
        private String ticket;

        public P4LoginInfo() {
        }

        public P4LoginInfo(String user, String ticket) {
            this.ticket = ticket;
            this.user = user;
        }

        public String getTicket() {
            return ticket;
        }

        public void setTicket(String ticket) {
            this.ticket = ticket;
        }

        /**
         * We do allow a single "login" to map to different accounts. This may happen in cases
         * where there are multiple p4ds but people have completely different logins in the
         * different systems.
         * <p>
         * Strange? Yes. Already deployed internally? Yes.
         *
         * @return
         */
        public String getUser() {
            return user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            P4LoginInfo that = (P4LoginInfo) o;

            if (user != null ? !user.equals(that.user) : that.user != null) return false;
            return ticket != null ? ticket.equals(that.ticket) : that.ticket == null;

        }

        @Override
        public int hashCode() {
            int result = user != null ? user.hashCode() : 0;
            result = 31 * result + (ticket != null ? ticket.hashCode() : 0);
            return result;
        }

        @Override
        public String toString() {
            return "P4LoginInfo{" +
                    "ticket='" + ticket + '\'' +
                    ", user='" + user + '\'' +
                    '}';
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SessionData that = (SessionData) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (p4LoginInfoMap != null ? !p4LoginInfoMap.equals(that.p4LoginInfoMap) : that.p4LoginInfoMap != null)
            return false;
        if (raymondTicket != null ? !raymondTicket.equals(that.raymondTicket) : that.raymondTicket != null)
            return false;
        return expires != null ? expires.equals(that.expires) : that.expires == null;

    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (p4LoginInfoMap != null ? p4LoginInfoMap.hashCode() : 0);
        result = 31 * result + (raymondTicket != null ? raymondTicket.hashCode() : 0);
        result = 31 * result + (expires != null ? expires.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "SessionData{" +
                "id=" + id +
                '}';
    }
}
