; Script generated by the My Inno Setup Extensions Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
; Script for P4WordDiff
; Created by Robert Cowham

[Setup]
AppName=P4OfficeDiff
AppVerName=1.0
AppPublisher=Robert Cowham
AppPublisherURL=http://www.vaccaperna.co.uk
AppSupportURL=http://www.vaccaperna.co.uk
AppUpdatesURL=http://www.vaccaperna.co.uk
DefaultDirName={code:InstallDir|{pf}\Perforce}
DirExistsWarning=no
DefaultGroupName=Perforce
; Where are all inputs kept? Relative to current dir
SourceDir=files
; Relative to SourceDir
OutputDir=..\Output
OutputBaseFilename=P4OfficeDiffSetup
PrivilegesRequired=poweruser

[Registry]
; P4Win configuration
Root: HKCU; Subkey: "Software\Perforce\P4Win\DiffAssocs"; ValueType: string; ValueName: "doc"; ValueData: "{app}\P4OfficeDiff.exe"; Flags: uninsdeletevalue
Root: HKCU; Subkey: "Software\Perforce\P4Win\DiffAssocs"; ValueType: string; ValueName: "docx"; ValueData: "{app}\P4OfficeDiff.exe"; Flags: uninsdeletevalue

[Files]
; VB Add-in Designer file
Source: "vbfiles\msaddndr.dll"; DestDir: "{cf}\Designer"; Flags: uninsneveruninstall regserver sharedfile

; VB system files
Source: "vbfiles\stdole2.tlb";  DestDir: "{sys}"; OnlyBelowVersion: 0,6; Flags: restartreplace uninsneveruninstall sharedfile regtypelib
Source: "vbfiles\msvbvm60.dll"; DestDir: "{sys}"; OnlyBelowVersion: 0,6; Flags: restartreplace uninsneveruninstall sharedfile regserver
Source: "vbfiles\oleaut32.dll"; DestDir: "{sys}"; OnlyBelowVersion: 0,6; Flags: restartreplace uninsneveruninstall sharedfile regserver
Source: "vbfiles\olepro32.dll"; DestDir: "{sys}"; OnlyBelowVersion: 0,6; Flags: restartreplace uninsneveruninstall sharedfile regserver
Source: "vbfiles\asycfilt.dll"; DestDir: "{sys}"; OnlyBelowVersion: 0,6; Flags: restartreplace uninsneveruninstall sharedfile
Source: "vbfiles\comcat.dll";   DestDir: "{sys}"; OnlyBelowVersion: 0,6; Flags: restartreplace uninsneveruninstall sharedfile regserver

; Diff program
Source: "P4OfficeDiff.exe"; DestDir: "{app}"; Flags: ignoreversion;
Source: "update_settings.exe"; DestDir: "{app}"; Flags: ignoreversion;

[Run]
Filename: "{app}\update_settings.exe"; Parameters: """{code:SettingsFilePath}"" ""{app}/P4OfficeDiff.exe"" "; Check: P4VInstalled

[UninstallRun]
Filename: "{app}\update_settings.exe"; Parameters: "-uninstall ""{code:SettingsFilePath}"" ""{app}/P4OfficeDiff.exe"" "; Check: P4VInstalled

[Code]
// This section is the Pascal script - various procedures called from above.
program Setup;
var
    bWord2000Installed: Boolean;
    bExcel2000Installed: Boolean;
    bPowerPoint2000Installed: Boolean;
    bOfficeXPInstalled: Boolean;
    bOffice2003Installed: Boolean;
    bOffice2007Installed: Boolean;
    bOffice2010Installed: Boolean;
    bOffice2013Installed: Boolean;
    bP4VInstalled: Boolean;

function IsAppRunning(const FileName : string): Boolean;
var
    FSWbemLocator: Variant;
    FWMIService   : Variant;
    FWbemObjectSet: Variant;
begin
    Result := false;
    FSWbemLocator := CreateOleObject('WBEMScripting.SWBEMLocator');
    FWMIService := FSWbemLocator.ConnectServer('', 'root\CIMV2', '', '');
    FWbemObjectSet := FWMIService.ExecQuery(Format('SELECT Name FROM Win32_Process Where Name like "%s"',[FileName]));
    Result := (FWbemObjectSet.Count > 0);
    FWbemObjectSet := Unassigned;
    FWMIService := Unassigned;
    FSWbemLocator := Unassigned;
end;

//---------------------------------------------------
// Called automatically at the start of initialization
function InitializeSetup(): Boolean;
var
    Path: String;
begin
    // Make sure an appropriate version of Office is installed!

    Result := True;

    if RegQueryStringValue(HKEY_CURRENT_USER,
             'Software\Microsoft\Office\9.0\Word\Options', 'PROGRAMDIR', Path) then
         bWord2000Installed := True;
    if RegQueryStringValue(HKEY_CURRENT_USER,
             'Software\Microsoft\Office\9.0\Excel\Options', 'PROGRAMDIR', Path) then
         bExcel2000Installed := True;
    if RegQueryStringValue(HKEY_CURRENT_USER,
             'Software\Microsoft\Office\9.0\PowerPoint\Options', 'PROGRAMDIR', Path) then
         bPowerPoint2000Installed := True;

    // Alternative place to look for Office 2000
    if RegQueryStringValue(HKEY_LOCAL_MACHINE,
             'Software\Microsoft\Office\9.0\Common\InstallRoot', 'Path', Path) then
    begin
         bWord2000Installed := True;
         bPowerPoint2000Installed := True;
         bExcel2000Installed := True;
    end;

    if RegQueryStringValue(HKEY_LOCAL_MACHINE,
            'Software\Microsoft\Office\10.0\Common\InstallRoot', 'Path', Path) then
         bOfficeXPInstalled := True;

    if RegQueryStringValue(HKEY_LOCAL_MACHINE,
            'Software\Microsoft\Office\11.0\Common\InstallRoot', 'Path', Path) then
         bOffice2003Installed := True;

    if RegQueryStringValue(HKEY_LOCAL_MACHINE,
            'Software\Microsoft\Office\12.0\Common\InstallRoot', 'Path', Path) then
         bOffice2007Installed := True;

    if RegQueryStringValue(HKEY_LOCAL_MACHINE,
            'Software\Microsoft\Office\14.0\Common\InstallRoot', 'Path', Path) then
         bOffice2010Installed := True;
         
    if RegQueryStringValue(HKEY_LOCAL_MACHINE,
            'Software\Microsoft\Windows\CurrentVersion\App Paths\excel.exe', 'Path', Path) or
       RegQueryStringValue(HKEY_LOCAL_MACHINE,
            'Software\Microsoft\Windows\CurrentVersion\App Paths\winword.exe', 'Path', Path) or
       RegQueryStringValue(HKEY_LOCAL_MACHINE,
            'Software\Microsoft\Windows\CurrentVersion\App Paths\powerpnt.exe', 'Path', Path)
            then
         bOffice2013Installed := True;

     if DirExists(ExpandConstant('{%USERPROFILE}\.p4qt')) then
         bP4VInstalled := True;

    if not bWord2000Installed and not bExcel2000Installed
        and not bPowerPoint2000Installed and not bOfficeXPInstalled
        and not bOffice2003Installed and not bOffice2007Installed 
        and not bOffice2010Installed and not bOffice2013Installed then
    begin
        Result := False;
        MsgBox('No component of Office 2000, XP, 2003, 2007, 2010 or 2013 is installed - installation of P4OfficeDiff cannot proceed!',
                mbError, MB_OK);
    end;

    if not bP4VInstalled then
    begin
        Result := False;
        MsgBox('P4V is not installed - installation of P4OfficeDiff cannot proceed!',
                mbError, MB_OK);
    end;

    if IsAppRunning('p4v%.exe') then
    begin
        Result := False;
        MsgBox('P4V is currently running - please close it and try to install P4OfficeDiff!',
                mbError, MB_OK);
    end;

end;

//----------------------------
function InstallDir(Default: String): String;
var
    Path: String;
begin

    // Value set up if Perforce is already installed
    if not RegQueryStringValue(HKEY_LOCAL_MACHINE,
        'Software\Perforce\Environment', 'P4INSTROOT', Path) then
    begin
        Path := Default;
    end;

    Result := Path;

end;

//----------------------------
// Following functions are for use with Check flags
function Office2000orGreater(): Boolean;
begin
    Result := False;
    if bWord2000Installed or bExcel2000Installed or bPowerPoint2000Installed or bOfficeXPInstalled or
       bOffice2003Installed or bOffice2007Installed or bOffice2010Installed or bOffice2013Installed then
        Result := True;
end;

function P4VInstalled(): Boolean;
begin
  Result := bP4VInstalled;
end;

function P4QTDir(): String;
begin
  Result := ExpandConstant('{%USERPROFILE}\.p4qt');
end;

function SettingsFilePath(Param: String): String;
begin
  Result := ExpandConstant(P4QTDir() + '\ApplicationSettings.xml');
end;

begin
end.
