# Installer for P4V

import sys
import os
import unittest
import getopt
import time
import re


sys.path.insert(0, os.path.join('..', 'src'))

log_filename = (time.strftime('update.%Y%m%dT%H%M%S.log',
                                 time.gmtime(time.time())))
log_filename = os.path.abspath(log_filename)
log_file = open(log_filename, "a")

def log_message(msg):
    date = time.strftime('%Y-%m-%d %H:%M:%S UTC',
                         time.gmtime(time.time()))
    log_file.write("%s  %s\n" % (date, msg))
    log_file.flush()

class TestCase(unittest.TestCase):
    def __call__(self, result=None):
        if result is None: result = self.defaultTestResult()
        self.result = result
        unittest.TestCase.__call__(self, result)

    def addFailure(self, msg):
        try:
            raise AssertionError, msg
        except AssertionError:
            self.result.addFailure(self,self._TestCase__exc_info())

class Test_base(TestCase):

    _test_app = r'..\src\update_settings\release\update_settings.exe'
    _app = os.path.abspath(os.path.join("..", "src", "p4worddiff.exe"))
            
    def log_result(self, msg="", output=[]):
        type, val, tb = sys.exc_info()
        log_message(msg + '\n' + string.join(traceback.format_stack(limit=2), ''))
        if len(output) > 0:
            import pprint
            pp = pprint.PrettyPrinter(indent=4)
            log_message(pp.pformat(output))
        if len(self.p4.warnings) > 0:
            log_message("Warnings: " + "\n".join(self.p4.warnings))
        if len(self.p4.errors) > 0:
            log_message("Errors: " + "\n".join(self.p4.errors))

    def run_test(self):
        pass
        
    def system(self, command, ignore_failure = 0, input_lines = None):
        log_file.write('Executing %s\n' % repr(command))
        (child_stdin, child_stdout) = os.popen4(command)
        if input_lines:
            child_stdin.writelines(input_lines)
            child_stdin.close()
        output = child_stdout.read()
        result = child_stdout.close()
        log_file.write(output)
        if not ignore_failure and result:
            message = ('Command "%s" failed with result code %d.' %
                       (command, result))
            log_file.write(message + '\n')
            raise message
        return output

    def copy_file(self, start_file, test_file):
        result = self.system("copy %s %s" % (start_file, test_file))
        if not re.compile(r"1 file\(s\) copied.").search(result):
            self.fail("Failed to copy file:\n%s" % (result))

    def compare_results(self, good_file, result_file):
        result = self.system("fc %s %s" % (good_file, result_file))
        if not re.compile("FC: no differences encountered").search(result):
            self.fail("Expected no differences comparing %s and %s." % (good_file, result_file))

    def test_file(self, input_file, test_file, expected_output):
        self.copy_file(input_file, test_file)
        cmd = "%s %s %s" % (self._test_app, test_file, self._app)
        result = self.system(cmd)
        self.compare_results(expected_output, test_file)    

#--- Test Cases

# Normal operation
class normal(Test_base):

    def runTest(self):
        "Test Normal files"
        self.test_file("appsettings2.xml", "appsettings.xml", "good_appsettings.xml")
        self.test_file("appsettings3.xml", "appsettings.xml", "good_appsettings3.xml")
        self.test_file("appsettings1.xml", "appsettings.xml", "good_appsettings.xml")

class old_style(Test_base):
        
    def runTest(self):
        "Test old style files"
        self.test_file("settings1.xml", "settings.xml", "good_settings.xml")
        self.test_file("settings2.xml", "settings.xml", "good_settings2.xml")
        
# RUNNING THE TESTS

def tests():
    if len(sys.argv) == 1:
        suite = unittest.TestSuite()
        # Decide which tests to run 
        
        # tests = [normal, new_assoc, new_pl, new_diffs]
        tests = [normal]
        for t in tests:
            suite.addTest(t())
        return suite
    else:
        # Unfortunately the following doesn't work with pdb, but is OK otherwise
        loader = unittest.defaultTestLoader
        module = __import__('__main__')
        suite = loader.loadTestsFromName(sys.argv[1], module)
        return suite        
        
def main():
    # Filter out our arguments before handing unknown ones on
    argv = []
    argv.append(sys.argv[0])
    try:                                
        opts, args = getopt.getopt(sys.argv[1:], "hv", 
                        ["help", "verbose"]) 
    except getopt.GetoptError:           
        print "Usage: -v/verbose"
        sys.exit(2)                     
        
    for opt, arg in opts:                
        if opt in ("-v", "--verbose"):      
            verbose = 1
            argv.append("-v")
        elif opt in ("-h", "--help"):
            argv.append("-h")   # pass it through
        else:   # If unknown pass them on
            argv.append(opt)
            argv.append(arg)
    # unittest.main(defaultTest="tests", argv=argv)
    runner = unittest.TextTestRunner(verbosity=2)
    runner.run(tests())
            
if __name__== '__main__':
    main()