// update_settings.cpp : Defines the entry point for the console application.
// This program updates the diff document settings for P4V.
// See below for parameters 

#include "stdafx.h"
#include "ticpp.h"

#include <string>
#include <iostream>
#include <windows.h>

using namespace std;

void dump(string name, ticpp::Element *elem)
{
	string value;
	cout << "Elem: " << name << endl;
	cout << "Text: (" << elem->GetText(false) << ")" << endl;
	elem->GetAttribute("varName", &value, false);
	cout << "varname: (" << value << ")" << endl;
	for (ticpp::Attribute *attr = elem->FirstAttribute(false);
			attr != NULL; attr = attr->Next(false))
	{
		cout << "Attr name: " << attr->Name() << " - " << attr->Value() <<endl;
	}
	cout << "--------" << endl;
}

ticpp::Element * new_element(ticpp::Element *parent, string name, string attribute, string value)
{
	ticpp::Element *elem = new ticpp::Element(name);
	if (attribute.length() > 0)
		elem->SetAttribute(attribute, value);
	parent->LinkEndChild(elem);
	return elem;
}

ticpp::Element * new_text(ticpp::Element *parent, string name, string value)
{
	ticpp::Element *elem = new ticpp::Element(name);
	elem->SetText(value);
	parent->LinkEndChild(elem);
	return elem;
}

void create_elements(ticpp::Element *prop_assoc, const string &app, const string &args)
{
	ticpp::Element *application = new_text(prop_assoc, "Application", app);
	ticpp::Element *arguments = new_text(prop_assoc, "Arguments", args);
}

void create_or_replace_assoc(ticpp::Element *prop_list, const string &app, const string &args, 
					   const string &extension, bool install)
{
	bool found_doc = false;
	ticpp::Element *prop_assoc = prop_list->FirstChildElement("Association", false);
	while (prop_assoc != NULL)
	{
		string varName;
		prop_assoc->GetAttributeOrDefault("varName", &varName, "");
		if (!varName.compare(extension))
		{
			found_doc = true;
			if (install)
			{
				ticpp::Element *application = prop_assoc->FirstChildElement("Application");
				ticpp::Element *arguments = prop_assoc->FirstChildElement("Arguments");
				// dump("application", application);
				// dump("arguments", arguments);
				application->SetText(app);
				arguments->SetText(args);
			}
			else	// uninstall
			{
				prop_list->RemoveChild(prop_assoc);
			}
			break;
		}
		prop_assoc = prop_assoc->NextSiblingElement(false);
	}
	if (!found_doc && install)
	{
		prop_assoc = new_element(prop_list, "Association", "varName", extension);
		create_elements(prop_assoc, app, args);
	}
}

void create_or_replace(ticpp::Document &doc, const string &app, const string &args, 
					   const string &extension, bool install)
{
	/*
	<PropertyList varName="ApplicationSettings" IsManaged="TRUE">
 	 <Associations varName="Merge Associations">
	  <RunExternal>false</RunExternal>
	  <Association varName="Default Association">
	   <Application>C:/Program Files/Araxis/Araxis Merge/AraxisP4WinMrg.exe</Application>
	   <Arguments>%b %1 %2 %r</Arguments>
	  </Association>
	 </Associations>
	 <Associations varName="DiffAssociations">
	  <RunExternal>true</RunExternal>
	  <Association varName="Default Association">
	   <Application>C:/Program Files/ExamDiff Pro/ExamDiff.exe</Application>
	   <Arguments>%1 %2</Arguments>
	  </Association>
	  <PropertyList varName="Associations" IsManaged="TRUE">
	   <Association varName="docx">
	    <Application>c:/program files/perforce/p4officediff.exe</Application>
	    <Arguments>%1 %2</Arguments>
	   </Association>
	  </PropertyList>
	 </Associations>
	</PropertyList>
	*/

	ticpp::Element *top_prop_list = doc.FirstChildElement("PropertyList");
	bool found_diff_assoc = false;
	ticpp::Element *assoc = top_prop_list->FirstChildElement("Associations", false);
	while (assoc != NULL)
	{
		string varName;
		assoc->GetAttributeOrDefault("varName", &varName, "");
		if (!varName.compare("DiffAssociations"))
		{
			found_diff_assoc = true;
			ticpp::Element *prop_list = assoc->FirstChildElement("PropertyList", false);
			if (prop_list)
			{
				create_or_replace_assoc(prop_list, app, args, extension, install);
			}
			else if (install)
			{
				prop_list = new_element(assoc, "PropertyList", "varName", "Associations");
				prop_list->SetAttribute("IsManaged", "TRUE");
				ticpp::Element *prop_assoc = new_element(prop_list, "Association", "varName", extension);
				create_elements(prop_assoc, app, args);
			}
			break;
		}
		assoc = assoc->NextSiblingElement(false);
	}
	if (!found_diff_assoc && install)
	{
		assoc = new_element(top_prop_list, "Associations", "varName", "DiffAssociations");
		ticpp::Element *prop_list = new_element(assoc, "PropertyList", "varName", "Associations");
		ticpp::Element *prop_assoc = new_element(prop_list, "Association", "varName", extension);
		create_elements(prop_assoc, app, args);
	}
}

void usage()
{
	printf("update_settings error!\n\nUsage:\n\n");
	printf("  update_settings [-uninstall] <settings_file> <application>\n\ne.g.:\n");
	printf("  update_settings \"c:\\docs\\.p4qt\\applicationsettings.xml\" \"c:/program/diff.exe\" \n");
}

int _tmain(int argc, _TCHAR* argv[])
{
	bool install = true;
	if (argc < 3 || argc > 4)
	{
		usage();
		return 2;
	}
	try
	{
		int i = 1;
		if (argc == 4)
		{
			string opt(argv[i++]);
			if (!opt.compare("-uninstall"))
				install = false;
			else
			{
				usage();
				return 2;
			}
		}
		string filename(argv[i++]);
		string app(argv[i++]);
		string args("%1 %2");
		bool new_style = false;
		OutputDebugString("Update_Settings, params:");
		OutputDebugString(filename.c_str());
		OutputDebugString(app.c_str());
		int j;
		while((j = app.find_first_of('\\')) >= 0)
			app.replace(j, 1, "/");
		ticpp::Document doc(filename);
		doc.LoadFile();
		create_or_replace(doc, app, args, "doc", install);
		create_or_replace(doc, app, args, "docx", install);
		create_or_replace(doc, app, args, "ppt", install);
		create_or_replace(doc, app, args, "pptx", install);
		doc.SaveFile(filename);

	}
	catch(ticpp::Exception& error)
	{
		cerr << "Error: " << error.m_details << endl;
		OutputDebugString("Error:");
		OutputDebugString(error.m_details.c_str());
		return 2;                 // signal error
	}  

	return 0;
}

