package com.perforce.workshop.tjuricek.initializer_gradle_plugin

import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * Adds the tasks and extensions to the project.
 */
class InitializerPlugin implements Plugin<Project> {

    @Override
    void apply(Project project) {
        project.extensions.add("perforceInitializer", InitializerExtension)
        project.task("initializePerforce", type:InitializePerforceTask, description: "Initialize running Perforce instance")
        project.tasks.initializePerforce.dependsOn("startPerforce")
    }
}
