title=Data
date=2014-06-05
type=page
status=published
~~~~~~

Initializer Data
================

The initializer is intended to be driven by data checked into a directory tree that probably looks something like this:

    data/
        0001_user_superuser.json
        0002_user_jdoe.json
        0010_depot_commons.json
        0020_trigger_commons-protection-updater.json
        0200_changelist_some_files.json
        0201_changelist_project_bar.json
        files/
            foo.txt
            bar.doc

The following conventions should be observed:

1. The files read by the initializer are all in a directory, and end with  the file extension `.json`

2. The test data files are either in the same directory, or in a sub directory.

3. Create all your users first, and make sure the first user is a super user.

Note that with Java-based integration, you have a lot more flexibility, since you determine the resource loader yourself. For command line usage, you'll need to basically organize everything into a single tree location like the one above.


## JSON Metadata Types ##

Currently, we only have these kinds of top level operations we define in each JSON file:

* `perforceChangelist` Create a changelist (currently just adds and edits)
* `perforceUser` Create a user
* `perforceClient` Create a client (you might not need this, read about temporary clients later)
* `perforceDepot` Create a depot
* `perforceTrigger` Create a trigger

Each JSON file starts with a `rank` property that's used to order each file with each other. (Out of convention, I've used this rank in a zero-padded string to let my directory list resemble the order the files will be read in.)


####  Temporary Clients

Each user will get a client just for the initialization run named `initializer-LOGIN`, e.g., `initializer-jdoe` for the login `jdoe`. Just reference this client by name in the JSON file to add files using this client. These clients should only exist during the initialization run; they should be deleted at the end of the run.

The clients you create directly using JSON files will stay around after the initialization run. This isn't widely used yet, so chances are you'll want to add features to really make use of them.


## Changelist JSON

Here's an example that adds a file:

    {
        "rank": 10,
        "perforceChangelist": {
            "login": "dumbo",
            "client": "initializer-dumbo",
            "description": "Just checkin things out",
            "adds": [
                {
                    "clientPath": "dev/main/wat.txt",
                    "resource": "stuff/wat.txt"
                }
            ]
        }
    }

Here's an example that edits the file in the next changelist:

    {
        "rank": 11,
        "perforceChangelist": {
            "login": "dumbo",
            "client": "initializer-dumbo",
            "description": "Just editing things",
            "edits": [
                {
                    "clientPath": "dev/main/wat.txt",
                    "resource": "stuff/wat2.txt"
                }
            ]
        }
    }


## User JSON

The first user should always be a super user. The user would look like this:

    {
        "rank": 1,
        "perforceUser": {
            "login": "super",
            "email": "super@example.com",
            "password": "superduper1A",
            "name": "Super Duper",
            "super": true
        }
    }

Additional (normal) users should just not include the `super` property.

    {
        "rank": 2,
        "perforceUser": {
            "login": "dumbo",
            "email": "dumbo@example.com",
            "password": "dumbodumbo1A",
            "name": "Dumbo McFly"
        }
    }

You can also create `admin` users, which will be given admin access in the protects table:

    {
        "rank": 3,
        "perforceUser": {
            "login": "boss",
            "email": "boss@example.com",
            "password": "bosswoman1A",
            "name": "Boss Woman",
            "admin": true
        }
    }

Finally, you can create `guest` users, which will be given `list` access in protects:


    {
        "rank": 4,
        "perforceUser": {
            "login": "guest",
            "email": "guest@example.com",
            "password": "guestuser1A",
            "name": "Guest User",
            "guest": true
        }
    }


## Client JSON

Here's an example of creating a client that should hang around:

    {
        "rank": 10,
        "perforceClient": {
            "name": "dumbo-client",
            "root": "/an/existing/directory",
            "owner": "dumbo",
            "description": "Dumbo's awesome client"
            "host": "myhost",
            "view": [
                [ "//depot/...", "//dumbo-client/..." ]
            ]
        }
    }

This feature isn't used frequently, most client management is done via test frameworks.


## Depot JSON

Creating a depot is one of the first things done when setting up an instance:

    {
        "rank": 10,
        "perforceDepot": {
            "name": "commons"
        }
    }


## Trigger JSON

Here's one of the trigger scripts:

    {
        "rank": 20,
        "perforceTrigger": {
            "bash": "templates/commons_protection_updater.sh",
            "batch": "templates/commons_protection_updater.bat",
            "triggerLines": [
                {
                    "name": "CommonsProtectionUpdater",
                    "type": "form-save",
                    "path": "group",
                    "command": "{_{command}} %formname% %user%"
                }
            ]
        }
    }

The `bash` and `batch` conventions are currently used for Unix vs Windows variations. If you don't run on windows, just don't include the `batch` variation.
