title=Overview
date=2014-06-05
type=page
status=published
~~~~~~

Initializer Overview
====================

When developing applications on top of the Perforce server, you often want to start with a server with real data in a sensible configuration. When these apps need to run against *multiple versions* of Perforce, you're faced with figuring out how to set up each instance in the same way. This is the job of the initializer: take a bunch of files and metadata, and set up your Perforce instance. Now, you can, say, run the same system tests in different configurations of Perforce.

The initializer uses a directory of .json files that describe changes to be made, along with versions of data to "seed" into the system. See the [Data](data.html) page for details of how to set this up. This directory is intended to be checked in with your system tests.

When you have the data set up, you'll then execute the initializer either using the command line, or, via gradle plugins. Both of these options are described below.


## Requirements

1. Java 8

2. A running Perforce instance, this tool does not actually download the p4d executable, and generally assumes you've just set it up without a lot of configuration


## Notable Restrictions

This system always sets security to level 2 at the moment.


## Executing using the Command Line

The first part of executing via the command line is downloading the "complete" jar distribution.

[Version 0.1.2](http://dl.bintray.com/tristanjuricek/generic/initializer/0.1.2/#initializer-complete.jar)

### Create A Configuration File

From here, you'll need to create a configuration file. Here's an example:

    options:
        dataRootDir:    src/test/perforce
        triggersDir:    build/perforce/work/triggers
        clientRootDir:  build/perforce/clients

This is a [YAML](http://yaml.org) file, so save this content in a file like `config.yml`.

The main directory you need is `dataRootDir`. This is the [data directory tree](data.html) contains all your JSON files and data to be seeded.

The `triggersDir` is used only if you're creating triggers; this is the directory we write out the trigger file for use by the Perforce instance.

The `clientRootDir` is used by all temporary clients as a working area.

Note that this assumes a Perforce instance is running on localhost:1666. If this is not the case, you'll need an additional section in the config file:

    connectionSettings:
        hostname:   localhost
        port:       1666

### Execution

Execute downloaded jar file with your configuration:

    % java -jar initializer-complete.jar config.yml



## Executing using Gradle

First, set up your `buildscript` repository configuration for both the `initializer-gradle-plugin` and the `perforce-gradle-plugin`:

    buildscript {
        repositories {
            jcenter()
        }
        dependencies {
            classpath("com.perforce.workshop.tjuricek:perforce-gradle-plugin:0.1.2")
            classpath("com.perforce.workshop.tjuricek:initializer-gradle-plugin:0.1.1")
        }
    }

Then, just apply the plugins:

    apply plugin: 'perforce'
    apply plugin: 'perforce-initializer'

You'll only need to then run the `initPerforce` task once:

    % ./gradlew initPerforce

From there, you can start and stop the test server using `stopPerforce` and `startPerforce` tasks.

This assumes that by default you've stored all your data under the `src/test/perforce`. You can reconfigure this:

    initializer {
        sources = project.file('another/directory')
    }

