package com.perforce.workshop.tjuricek.p4java_ext;

import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.Assert;
import org.testng.annotations.Test;

import java.io.File;

/**
 * Some basic checks of creating a client in P4, setting up mappings, etc.
 */
public class P4ClientTest {

    P4Connection p4Connection = null;
    P4Client p4Client = null;

    @BeforeClass
    public void connect() {
        p4Connection = P4Connection.create("localhost", 1666, false, "p4java_ext", "0.1");
        p4Connection.connectAs("super");
        p4Client = P4Client.create(p4Connection);
    }

    @Test
    public void createClient() {
        String clientName = "test-client-" + System.currentTimeMillis();

        ClientSpec clientSpec = p4Client.load(clientName);

        clientSpec.put("Root", clientRoot().getAbsolutePath());

        clientSpec.clearView();

        clientSpec.addMapping("//depot/main/project/...",
                "//" + clientName + "/...");

        p4Client.save(clientSpec);

        ClientSpec saved = p4Client.load(clientName);

        Assert.assertEquals(saved.get("Root"), clientSpec.get("Root"));
        Assert.assertEquals(saved.getView(), clientSpec.getView());
    }

    @AfterClass
    public void disconnect() {
        p4Connection.disconnect();
    }

    public File clientRoot() {
        return TestUtils.testFile("P4ClientTest");
    }
}
