package com.perforce.workshop.tjuricek.p4java_ext;

import java.io.File;

/**
 */
public class TestUtils {

    /**
     * Generates a path underneath this project's build/test-data folder.
     *
     * @param paths The path components, can be folders or files,
     *              this doesn't care
     * @return A File object representing the path, doesn't need to exist, nor
     *         do the parent folders
     */
    public static File testFile(String ... paths) {
        File path = projectRoot();
        path = new File(path, "build");
        path = new File(path, "test-data");

        for (String p : paths) {
            path = new File(path, p);
        }

        return path;
    }

    /**
     * Returns a file from the root of the main commons tree.
     */
    public static File projectFile(String ... paths) {
        File path = projectRoot();
        for (String p : paths) {
            path = new File(path, p);
        }
        return path;
    }

    /**
     * Returns the root path of the main commons project.
     * @return
     */
    public static File projectRoot() {
        File cur = new File(System.getProperty("user.dir"));
        while (cur != null && !containsFiles(cur, "gradlew")) {
            cur = cur.getParentFile();
        }
        if (cur == null) {
            throw new IllegalStateException("Did not locate gradlew in the " +
                    "tree which probably means the test process was not " +
                    "started within the source tree.");
        }
        return cur;
    }

    /**
     * Returns true when all filenames exist in the indicated directory.
     */
    public static boolean containsFiles(File dir, String... names) {
        for (String n : names) {
            File f = new File(dir, n);
            if (!f.exists()) {
                return false;
            }
        }
        return true;
    }
}
