package com.perforce.workshop.tjuricek.p4java_ext;

import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.util.List;

/**
 * Smoke test usage of 'p4 protect' command.
 */
public class P4ProtectTest {

    P4Connection connection = null;
    P4Protect p4Protect = null;

    @BeforeClass
    public void connect() {
        connection = P4Connection.create("localhost", 1666, false, "p4java_ext", "0.1");
        connection.connectAs("super");
        p4Protect = P4Protect.fromConnection(connection);
    }


    @Test(groups = "protectsTests", dependsOnGroups = "userTests")
    public void updateProtect() throws Exception {
        ProtectSpec spec = p4Protect.load();

        Permission permission = new Permission();
        permission.setAccessLevel("list");
        permission.setUserGroup("user");
        permission.setName("another-user");
        permission.setHost("*");
        permission.setFiles("//...");

        spec.addPermission(permission);

        p4Protect.save(spec);

        ProtectSpec updated = p4Protect.load();

        List<Permission> newPermissions = updated.getProtections();

        Permission updatedPerm = null;
        for (Permission newPermission : newPermissions) {
            if (newPermission.getName().equals("another-user")) {
                updatedPerm = newPermission;
                break;
            }
        }

        Assert.assertNotNull(updatedPerm, "did not update another-user permission");
        Assert.assertEquals(updatedPerm.getAccessLevel(), "list");
        Assert.assertEquals(updatedPerm.getUserGroup(), "user");
        Assert.assertEquals(updatedPerm.getHost(), "*");
        Assert.assertEquals(updatedPerm.getFiles(), "//...");
    }

    @AfterClass
    public void disconnect() {
        connection.disconnect();
    }
}
