package com.perforce.workshop.tjuricek.p4java_ext;

import com.perforce.p4java.exception.P4JavaException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/**
 * Validates being able to load and update users.
 */
public class P4UserTest {

    P4Connection connection = null;
    P4User p4User = null;

    @BeforeClass
    public void connect() {
        connection = P4Connection.create("localhost", 1666, false, "p4java_ext", "0.1");
        connection.connectAs("super");
        p4User = P4User.fromConnection(connection);
    }

    @Test(groups = "userTests")
    public void createUser() throws P4JavaException {
        String userName = "user";
        p4User.connectAs(userName);
        UserSpec loaded = p4User.load(userName);

        loaded.setEmail(userName + "@example.com");
        loaded.setFullName("Test User");
        loaded.setPassword("example");

        p4User.save(loaded);

        // We now have to log in, since we just changed the password
        connection.getOptionsServer().login("example");

        UserSpec updated = p4User.load(userName);

        Assert.assertEquals(updated.getLogin(), loaded.getLogin());
        Assert.assertEquals(updated.getEmail(), loaded.getEmail());
        Assert.assertEquals(updated.getFullName(), loaded.getFullName());
    }

    @Test(dependsOnMethods = "createUser", groups = "userTests")
    public void createAnotherUser() throws P4JavaException {
        String userName = "another-user";
        UserSpec loaded = p4User.load(userName);

        loaded.setEmail(userName + "@example.com");
        loaded.setFullName("Another Test User");
        loaded.setPassword(userName);

        p4User.forceSave(loaded);

        UserSpec updated = p4User.load(userName);

        Assert.assertEquals(updated.getLogin(), loaded.getLogin());
        Assert.assertEquals(updated.getEmail(), loaded.getEmail());
        Assert.assertEquals(updated.getFullName(), loaded.getFullName());
    }

    @AfterClass
    public void disconnect() {
        connection.disconnect();
    }

}
